
var i18nLanguage = "zh-CN";
//var choice;
// function language(v){
//     if(v == 0){
//         i18nLanguage = "zh-CN";
//     }else if(v == 1){
//         i18nLanguage = "en";
//     }
//     //更改语言后将语言类型存入cookie
//     getCookie("userLanguage",i18nLanguage,{
//         expires: 30,//cookie过期时间
//         path:'/'
//     });
//     loadProperties();
// }
/**
 * cookie操作
 */
function getCookie(name, value, options) {
    if (typeof value != 'undefined') { // name and value given, set cookie
        options = options || {};
        if (value === null) {
            value = '';
            options.expires = -1;
        }
        var expires = '';
        if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
            var date;
            if (typeof options.expires == 'number') {
                date = new Date();
                date.setTime(date.getTime() + (options.expires * 24 * 60 * 60 * 1000));
            } else {
                date = options.expires;
            }
            expires = '; expires=' + date.toUTCString(); // use expires attribute, max-age is not supported by IE
        }
        var path = options.path ? '; path=' + options.path : '';
        var domain = options.domain ? '; domain=' + options.domain : '';
        var s = [cookie, expires, path, domain, secure].join('');
        var secure = options.secure ? '; secure' : '';
        var c = [name, '=', encodeURIComponent(value)].join('');
        var cookie = [c, expires, path, domain, secure].join('')
        document.cookie = cookie;
    } else {
        //给出名称，获取cookie
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = jQuery.trim(cookies[i]);
                // 这个Cookie字符串是否以我们想要的名称开头
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    }
};

function loadProperties(){
    if (getCookie("userLanguage")) {
        //取cookie
        i18nLanguage = getCookie("userLanguage");
    }
    jQuery.i18n.properties({//加载资浏览器语言对应的资源文件
        name:'strings', //资源文件名称
        path:'../static/js/i18n/' + i18nLanguage + '/', //资源文件路径
        mode:'map', //用Map的方式使用资源文件中的值
        callback: function() {
            //加载成功后设置显示内容
            var insertEle = $(".i18n");
            insertEle.each(function() {
                // 根据i18n元素的 name 获取内容写入
                $(this).html($.i18n.prop($(this).attr('name')));
            });
            var insertInputEle = $(".i18n-input");
            insertInputEle.each(function() {
                var selectAttr = $(this).attr('selectattr');
                if (!selectAttr) {
                    selectAttr = "value";
                };
                $(this).attr(selectAttr, $.i18n.prop($(this).attr('selectname')));
            });
            var insertTitleEle = $(".i18n-title");
            insertTitleEle.each(function() {
                $(this).attr("title",$.i18n.prop($(this).attr('name')));
            });
            var inserChildNodes = $(".i18n-ChildNodes");
            inserChildNodes.each(function() {
                $(this)[0].childNodes[0].nodeValue = $.i18n.prop($(this).attr('name'));
            });
            var inserChildNodes1 = $(".i18n-ChildNodes1");
            inserChildNodes1.each(function() {
                if($(this)[0].childNodes[2] !== undefined){
                    $(this)[0].childNodes[2].nodeValue = $.i18n.prop($(this).attr('name'));
                }else if($(this)[0].childNodes[1] !== undefined){
                    $(this)[0].childNodes[1].nodeValue = $.i18n.prop($(this).attr('name'));
                }else{
                    console.log($(this)[0]);
                }
            });
        }
    });
}
